/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.Privileges;
import com.mckoi.database.SchemaDef;
import com.mckoi.database.TType;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.UserAccessException;
import com.mckoi.database.interpret.ColumnChecker;
import com.mckoi.database.interpret.ColumnDef;
import com.mckoi.database.interpret.ConstraintDef;
import com.mckoi.database.interpret.Statement;
import java.util.ArrayList;

public class CreateTable
extends Statement {
    boolean temporary = false;
    boolean only_if_not_exists = false;
    String table_name;
    ArrayList columns;
    ArrayList constraints;
    private TableName tname;

    void addConstraintDef(ConstraintDef constraint) {
        this.constraints.add(constraint);
    }

    DataTableDef createDataTableDef() throws DatabaseException {
        DataTableDef table_def = new DataTableDef();
        table_def.setTableName(this.tname);
        table_def.setTableClass("com.mckoi.database.VariableSizeDataTableFile");
        for (int i = 0; i < this.columns.size(); ++i) {
            DataTableColumnDef cd = (DataTableColumnDef)this.columns.get(i);
            table_def.addColumn(cd);
        }
        return table_def;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void addSchemaConstraint(DatabaseConnection manager, TableName table, ConstraintDef constraint) throws DatabaseException {
        if (constraint.type == 1) {
            manager.addPrimaryKeyConstraint(table, constraint.getColumnList(), constraint.deferred, constraint.name);
            return;
        } else if (constraint.type == 3) {
            TableName ref_table = TableName.resolve(constraint.reference_table_name);
            String update_rule = constraint.getUpdateRule().toUpperCase();
            String delete_rule = constraint.getDeleteRule().toUpperCase();
            if (!table.getSchema().equals(ref_table.getSchema())) throw new DatabaseException("Foreign key reference error: Not permitted to reference a table outside of the schema: " + table + " -> " + ref_table);
            manager.addForeignKeyConstraint(table, constraint.getColumnList(), ref_table, constraint.getColumnList2(), delete_rule, update_rule, constraint.deferred, constraint.name);
            return;
        } else if (constraint.type == 2) {
            manager.addUniqueConstraint(table, constraint.getColumnList(), constraint.deferred, constraint.name);
            return;
        } else {
            if (constraint.type != 4) throw new DatabaseException("Unrecognized constraint type.");
            manager.addCheckConstraint(table, constraint.original_check_expression, constraint.deferred, constraint.name);
        }
    }

    static DataTableColumnDef convertColumnDef(ColumnDef cdef) {
        TType type = cdef.type;
        DataTableColumnDef dtcdef = new DataTableColumnDef();
        dtcdef.setName(cdef.name);
        dtcdef.setNotNull(cdef.isNotNull());
        dtcdef.setFromTType(type);
        if (cdef.index_str != null) {
            dtcdef.setIndexScheme(cdef.index_str);
        }
        if (cdef.default_expression != null) {
            dtcdef.setDefaultExpression(cdef.original_default_expression);
        }
        dtcdef.initTTypeInfo();
        return dtcdef;
    }

    void setupAllConstraints() throws DatabaseException {
        for (int i = 0; i < this.constraints.size(); ++i) {
            ConstraintDef constraint = (ConstraintDef)this.constraints.get(i);
            CreateTable.addSchemaConstraint(this.database, this.tname, constraint);
        }
    }

    public void prepare() throws DatabaseException {
        int i;
        this.temporary = this.cmd.getBoolean("temporary");
        this.only_if_not_exists = this.cmd.getBoolean("only_if_not_exists");
        this.table_name = (String)this.cmd.getObject("table_name");
        ArrayList column_list = (ArrayList)this.cmd.getObject("column_list");
        this.constraints = (ArrayList)this.cmd.getObject("constraint_list");
        int size = column_list.size();
        this.columns = new ArrayList(size);
        for (int i2 = 0; i2 < size; ++i2) {
            ColumnDef cdef = (ColumnDef)column_list.get(i2);
            this.columns.add(CreateTable.convertColumnDef(cdef));
        }
        String schema_name = this.database.getCurrentSchema();
        this.tname = TableName.resolve(schema_name, this.table_name);
        String name_strip = this.tname.getName();
        if (name_strip.indexOf(46) != -1) {
            throw new DatabaseException("Table name can not contain '.' character.");
        }
        final boolean ignores_case = this.database.isInCaseInsensitiveMode();
        ColumnChecker checker = new ColumnChecker(){

            String resolveColumnName(String col_name) throws DatabaseException {
                String found_col = null;
                for (int n = 0; n < CreateTable.this.columns.size(); ++n) {
                    DataTableColumnDef col = (DataTableColumnDef)CreateTable.this.columns.get(n);
                    if (!ignores_case) {
                        if (!col.getName().equals(col_name)) continue;
                        return col_name;
                    }
                    if (!col.getName().equalsIgnoreCase(col_name)) continue;
                    if (found_col != null) {
                        throw new DatabaseException("Ambiguous column name '" + col_name + "'");
                    }
                    found_col = col.getName();
                }
                return found_col;
            }
        };
        ArrayList<String> unique_column_list = new ArrayList<String>();
        ArrayList<String> primary_key_column_list = new ArrayList<String>();
        for (i = 0; i < this.columns.size(); ++i) {
            DataTableColumnDef cdef = (DataTableColumnDef)this.columns.get(i);
            ColumnDef model_cdef = (ColumnDef)column_list.get(i);
            checker.checkExpression(cdef.getDefaultExpression(this.database.getSystem()));
            String col_name = cdef.getName();
            cdef.setName(ColumnChecker.stripTableName(name_strip, col_name));
            if (model_cdef.isUnique()) {
                unique_column_list.add(col_name);
            }
            if (!model_cdef.isPrimaryKey()) continue;
            primary_key_column_list.add(col_name);
        }
        if (unique_column_list.size() > 0) {
            ConstraintDef constraint = new ConstraintDef();
            constraint.setUnique(unique_column_list);
            this.addConstraintDef(constraint);
        }
        if (primary_key_column_list.size() > 0) {
            ConstraintDef constraint = new ConstraintDef();
            constraint.setPrimaryKey(primary_key_column_list);
            this.addConstraintDef(constraint);
        }
        for (i = 0; i < this.constraints.size(); ++i) {
            ConstraintDef constraint = (ConstraintDef)this.constraints.get(i);
            ColumnChecker.stripColumnList(name_strip, constraint.column_list);
            if (constraint.type == 3) {
                DataTableDef ref_table_def;
                ColumnChecker.stripColumnList(constraint.reference_table_name, constraint.column_list2);
                TableName ref_tname = this.resolveTableName(constraint.reference_table_name, this.database);
                if (this.database.isInCaseInsensitiveMode()) {
                    ref_tname = this.database.tryResolveCase(ref_tname);
                }
                constraint.reference_table_name = ref_tname.toString();
                if (this.database.tableExists(ref_tname)) {
                    ref_table_def = this.database.getDataTableDef(ref_tname);
                } else if (ref_tname.equals(this.tname)) {
                    ref_table_def = this.createDataTableDef();
                } else {
                    throw new DatabaseException("Referenced table '" + ref_tname + "' in constraint '" + constraint.name + "' does not exist.");
                }
                ref_table_def.resolveColumnsInArray(this.database, constraint.column_list2);
            }
            checker.checkExpression(constraint.check_expression);
            checker.checkColumnList(constraint.column_list);
        }
    }

    public Table evaluate() throws DatabaseException {
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        boolean ignore_case = this.database.isInCaseInsensitiveMode();
        SchemaDef schema = this.database.resolveSchemaCase(this.tname.getSchema(), ignore_case);
        if (schema == null) {
            throw new DatabaseException("Schema '" + this.tname.getSchema() + "' doesn't exist.");
        }
        this.tname = new TableName(schema.getName(), this.tname.getName());
        if (!this.database.getDatabase().canUserCreateTableObject(context, this.user, this.tname)) {
            throw new UserAccessException("User not permitted to create table: " + this.table_name);
        }
        if (!this.database.tableExists(this.tname)) {
            DataTableDef table_def = this.createDataTableDef();
            this.database.createTable(table_def);
            this.database.getGrantManager().addGrant(Privileges.TABLE_ALL_PRIVS, 1, this.tname.toString(), this.user.getUserName(), true, "@SYSTEM");
            this.setupAllConstraints();
            return FunctionTable.resultTable(context, 0);
        }
        if (!this.only_if_not_exists) {
            throw new DatabaseException("Table '" + this.tname + "' already exists.");
        }
        return FunctionTable.resultTable(context, 0);
    }
}

